## [Spatial Understanding]()
Scripts, Prefabs, and Test Scenes that leverage Spatial Understanding related features.

See the [HoloToolkit Spatial Mapping](../SpatialMapping) documentation to ensure your project is set up correctly.

**IMPORTANT**: Please make sure to add the Spatial Perception capability in your app, in Unity under  
Edit -> Project Settings -> Player -> Settings for Windows Store -> Publishing Settings -> Capabilities  
or in your Visual Studio Package.appxmanifest capabilities.

### Microsoft HoloLens Documentation
- [Spatial Mapping In Unity](https://developer.microsoft.com/en-us/windows/mixed-reality/spatial_mapping_in_unity)
- [Spatial Understanding In Unity](https://developer.microsoft.com/en-us/windows/mixed-reality/spatial_mapping_in_unity#holotoolkit.spatialunderstanding)

### Case studies
- [Expanding the spatial mapping capabilities of HoloLens](https://developer.microsoft.com/en-us/windows/mixed-reality/case_study_-_expanding_the_spatial_mapping_capabilities_of_hololens)

### [Plugins](Plugins)
SpatialUnderstanding addon that can be used for topology, object detection, and object placement.

### [Prefabs](Prefabs)
The following prefab makes it easy to quickly get started using the Spatial Understanding Modules.

#### SpatialUnderstanding.prefab
This prefab is used to control the state and flow of the scanning process used in the understanding module, provides the means to visualize the scanning process.

### [Scripts](Scripts)

#### SpatialUnderstanding.cs
The SpatialUnderstanding class controls the state and flow of the scanning process used in the understanding module.

#### SpatialUnderstandingCustomMesh.cs
Handles the custom meshes generated by the understanding dll. The meshes are generated during the scanning phase and once more on scan finalization. The meshes can be used to visualize the scanning progress.

#### SpatialUnderstandingDll.cs
Encapsulates the primary dll functions, including marshalling helper functions. The dll functions are organized into four parts - in this behavior, SpatialUnderstandingDllTopology, SpatialUnderstandingDllShapes, and SpatialUnderstandingDllObjectPlacement. The scan flow, raycast, and alignment functions are included in this class.

#### SpatialUnderstandingDllObjectPlacement.cs
Encapsulates the object placement queries of the understanding dll. These queries will not be valid until after scanning is finalized.

#### SpatialUnderstandingDllShapes.cs
Encapsulates the shape detection queries of the understanding dll. Shapes are defined by the user with AddShape and the analysis is 
initiated with ActivateShapeAnalysis. These queries will not be valid until after scanning is finalized.

Shape definitions are composed of a list of components and a list of shape constraints which defining requirements between the 
components. Each component is defined by a list of its own shape component constraints.

#### SpatialUnderstandingDllTopology.cs
Encapsulates the topology queries of the understanding dll. These queries will not be valid until after scanning is finalized.

#### SpatialUnderstandingSourceMesh.cs
Provides the input meshes to the spatial understanding dll. The component relies on the spatial mapping module. It maintains
a mesh list in the required dll format which is updated from the spatial mapping's SurfaceObject list.

### [Shaders](Materials)

#### SpatialMappingSurface.shader
A basic wire frame shader that can be used for rendering Spatial Mapping meshes.

#### SpatialUnderstandingSurface.shader
A basic wire frame shader that can be used for rendering Spatial Understanding Surfaces.

---
##### [Go back up to the table of contents.](../../../README.md)
---
